<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #495057;
    }

    /* Container */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 15px;
    }

    /* Spacing */
    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    .p-4 {
        padding: 1.5rem !important;
    }

    .p-md-5 {
        padding: 3rem !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .my-4 {
        margin-top: 1.5rem !important;
        margin-bottom: 1.5rem !important;
    }

    .mt-4 {
        margin-top: 1.5rem !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .justify-content-center {
        justify-content: center;
    }

    .col-lg-10 {
        flex: 0 0 calc(83.333% - 12px);
    }

    .col-md-6 {
        flex: 0 0 calc(50% - 12px);
    }

    /* Typography */
    h2 {
        font-size: 32px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 0.5rem;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
    }

    p {
        font-size: 14px;
        color: #495057;
        margin: 0;
    }

    .lead {
        font-size: 18px;
        font-weight: 300;
        color: #6c757d;
    }

    .fw-bold {
        font-weight: 700;
    }

    .text-center {
        text-align: center;
    }

    .text-primary {
        color: var(--primary-color) !important;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-danger {
        color: var(--danger-red) !important;
    }

    .text-white {
        color: #fff !important;
    }

    /* Cards */
    .card {
        background: #fff;
        border-radius: 12px;
        border: none;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .card-body {
        padding: 1.5rem;
    }

    .border-0 {
        border: none !important;
    }

    .shadow {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    /* Alert */
    .alert {
        padding: 1rem;
        border-radius: 8px;
        border: none;
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 1.5rem;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
    }

    .alert-warning {
        background: #fff3cd;
        color: #856404;
    }

    .alert-info {
        background: #d1ecf1;
        color: #0c5460;
    }

    .alert-dismissible {
        position: relative;
        padding-right: 2.5rem;
    }

    .btn-close {
        position: absolute;
        top: 0.5rem;
        right: 0.5rem;
        background: transparent;
        border: none;
        font-size: 20px;
        cursor: pointer;
        opacity: 0.7;
        transition: opacity 0.2s;
        color: inherit;
    }

    .btn-close:hover {
        opacity: 1;
    }

    .fade {
        opacity: 1;
        transition: opacity 0.15s linear;
    }

    .show {
        opacity: 1;
    }

    /* Icons */
    i {
        margin-right: 4px;
    }

    .fa-3x {
        font-size: 3em;
    }

    /* Forms */
    .form-label {
        font-size: 14px;
        font-weight: 600;
        color: #231f20;
        margin-bottom: 8px;
        display: block;
    }

    .form-control,
    .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        color: #495057;
        background-color: #fff;
        border: 1px solid #dee2e6;
        border-radius: 6px;
        transition: all 0.3s ease;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .form-control:focus,
    .form-select:focus {
        color: #495057;
        background-color: #fff;
        border-color: var(--primary-color);
        outline: 0;
        box-shadow: 0 0 0 3px rgba(242, 97, 36, 0.1);
    }

    .form-control::placeholder {
        color: #adb5bd;
    }

    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }

    textarea.form-control[rows="2"] {
        min-height: 60px;
    }

    textarea.form-control[rows="3"] {
        min-height: 90px;
    }

    textarea.form-control[rows="4"] {
        min-height: 120px;
    }

    .form-text {
        font-size: 12px;
        color: #6c757d;
        display: block;
        margin-top: 4px;
    }

    small.text-danger {
        font-size: 12px;
        color: var(--danger-red) !important;
        display: block;
        margin-top: 4px;
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-lg {
        padding: 12px 20px;
        font-size: 16px;
    }

    .d-grid {
        display: grid;
    }

    .gap-2 {
        gap: 0.5rem;
    }

    .w-100 {
        width: 100%;
    }

    /* Horizontal Rule */
    hr {
        border: none;
        border-top: 1px solid #e9ecef;
        margin: 1.5rem 0;
    }

    /* Links */
    a {
        color: var(--primary-color);
        text-decoration: none;
        transition: all 0.2s ease;
    }

    a:hover {
        color: #d95520;
        text-decoration: underline;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .col-lg-10 {
            flex: 0 0 100%;
        }

        .row {
            gap: 16px;
        }

        .p-md-5 {
            padding: 1.5rem !important;
        }
    }

    @media (max-width: 768px) {
        .col-md-6 {
            flex: 0 0 100%;
        }

        .py-5 {
            padding-top: 2rem !important;
            padding-bottom: 2rem !important;
        }

        .card-body {
            padding: 1rem;
        }

        h2 {
            font-size: 24px;
        }

        h5 {
            font-size: 14px;
        }

        .lead {
            font-size: 16px;
        }

        .btn-lg {
            padding: 10px 16px;
            font-size: 14px;
        }

        .form-control,
        .form-select {
            padding: 10px;
            font-size: 13px;
        }

        textarea.form-control[rows="2"] {
            min-height: 50px;
        }

        textarea.form-control[rows="3"] {
            min-height: 75px;
        }

        textarea.form-control[rows="4"] {
            min-height: 100px;
        }

        .alert {
            padding: 0.75rem;
            font-size: 13px;
        }

        .btn-close {
            top: 0.25rem;
            right: 0.25rem;
        }

        .fa-3x {
            font-size: 2.5em;
        }
    }

    @media (max-width: 576px) {
        .container {
            padding: 0 10px;
        }

        .card {
            margin-bottom: 1rem;
        }

        .card-body {
            padding: 0.75rem;
        }

        h2 {
            font-size: 20px;
        }

        h5 {
            font-size: 13px;
        }

        p {
            font-size: 13px;
        }

        .lead {
            font-size: 14px;
        }

        .form-control,
        .form-select {
            padding: 8px 10px;
            font-size: 13px;
        }

        .form-label {
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
        }

        .btn-lg {
            padding: 10px 12px;
            font-size: 12px;
        }

        .fa-3x {
            font-size: 2em;
        }

        .my-4 {
            margin-top: 1rem !important;
            margin-bottom: 1rem !important;
        }

        .mt-4 {
            margin-top: 1rem !important;
        }
    }
</style>

<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Flash Messages -->
<?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('warning')): ?>
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('warning'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($this->session->flashdata('info')): ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <i class="fas fa-info-circle"></i> <?php echo $this->session->flashdata('info'); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <div class="text-center mb-4">
                        <i class="fas fa-hands-helping fa-3x text-primary mb-3"></i>
                        <h2 class="fw-bold">Volunteer Application</h2>
                        <p class="lead text-muted">Join our team and make a difference!</p>
                    </div>
                    
                    <?php echo form_open_multipart('volunteer/submit', array('id' => 'volunteerForm')); ?>
                        
                        <h5 class="fw-bold mb-3 text-primary">Personal Information</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Full Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="full_name" value="<?php echo set_value('full_name'); ?>" placeholder="Your full name" required>
                                <?php echo form_error('full_name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" value="<?php echo set_value('email'); ?>" placeholder="Your email address" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" name="phone" value="<?php echo set_value('phone'); ?>" placeholder="Your phone number" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Date of Birth</label>
                                <input type="date" class="form-control" name="date_of_birth" value="<?php echo set_value('date_of_birth'); ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Address <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="address" rows="2" placeholder="Your residential address" required><?php echo set_value('address'); ?></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">City <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="city" value="<?php echo set_value('city'); ?>" placeholder="Your city" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Country</label>
                                <input type="text" class="form-control" name="country" value="<?php echo set_value('country', 'Ghana'); ?>" placeholder="Your country">
                            </div>
                        </div>
                        
                        <hr class="my-4">
                        
                        <h5 class="fw-bold mb-3 text-primary">Professional Information</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Occupation <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="occupation" value="<?php echo set_value('occupation'); ?>" placeholder="Your profession" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Skills <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="skills" value="<?php echo set_value('skills'); ?>" 
                                       placeholder="e.g., Teaching, Event Planning" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Availability <span class="text-danger">*</span></label>
                            <select class="form-select" name="availability" required>
                                <option value="">-- Select --</option>
                                <option value="weekdays" <?php echo set_select('availability', 'weekdays'); ?>>Weekdays</option>
                                <option value="weekends" <?php echo set_select('availability', 'weekends'); ?>>Weekends</option>
                                <option value="flexible" <?php echo set_select('availability', 'flexible'); ?>>Flexible</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Areas of Interest <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="areas_of_interest" rows="3" placeholder="What areas would you like to contribute to?" required><?php echo set_value('areas_of_interest'); ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Previous Volunteer Experience</label>
                            <textarea class="form-control" name="previous_experience" rows="3" placeholder="Tell us about your previous volunteer work (optional)"><?php echo set_value('previous_experience'); ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Why do you want to volunteer? <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="motivation" rows="4" placeholder="Share your motivation and what you hope to achieve" required><?php echo set_value('motivation'); ?></textarea>
                        </div>
                        
                        <hr class="my-4">
                        
                        <h5 class="fw-bold mb-3 text-primary">Emergency Contact</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Contact Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="emergency_contact_name" value="<?php echo set_value('emergency_contact_name'); ?>" placeholder="Emergency contact name" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Contact Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" name="emergency_contact_phone" value="<?php echo set_value('emergency_contact_phone'); ?>" placeholder="Emergency contact phone" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Profile Photo <small class="text-muted">(Optional)</small></label>
                            <input type="file" class="form-control" name="profile_photo" accept="image/*">
                            <small class="form-text text-muted">JPG, PNG - Max 2MB</small>
                        </div>
                        
                        <div class="d-grid gap-2 mt-4">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-check"></i> Submit Application
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
</div>